// main.js
import { auth } from "./firebase-config.js";
import { sendMessage, getMessages } from "./chat.js";

document.addEventListener('DOMContentLoaded', () => {
    const messagesContainer = document.getElementById('messages');

    getMessages((messages) => {
        messagesContainer.innerHTML = '';
        messages.forEach(message => {
            const messageElement = document.createElement('div');
            messageElement.textContent = `${message.sender}: ${message.content}`;
            messagesContainer.appendChild(messageElement);
        });
    });

    document.getElementById('sendMessageForm').addEventListener('submit', (e) => {
        e.preventDefault();
        const sender = auth.currentUser.email;
        const content = e.target.message.value;
        sendMessage(sender, content);
        e.target.message.value = '';
    });
});
