// auth.js
import { getAuth, createUserWithEmailAndPassword, signInWithEmailAndPassword } from "firebase/auth";
import { getFirestore, doc, setDoc } from "firebase/firestore";
import { auth, db } from "./firebase-config.js";

const register = async (email, password, username) => {
    try {
        const userCredential = await createUserWithEmailAndPassword(auth, email, password);
        console.log('Usuário registrado:', userCredential.user);
        
        // Adicionar o nome de usuário ao Firestore
        await setDoc(doc(db, "users", userCredential.user.uid), {
            username: username,
            email: email
        });
    } catch (error) {
        console.error('Erro ao registrar:', error);
        throw error;
    }
};

const login = (email, password) => {
    signInWithEmailAndPassword(auth, email, password)
        .then((userCredential) => {
            console.log('Usuário logado:', userCredential.user);
        })
        .catch((error) => {
            console.error('Erro ao logar:', error);
        });
};

export { register, login };
